/*!
 * jquery.instagramFeed
 *
 * @version 1.2.7
 *
 * @author Javier Sanahuja Liebana <bannss1@gmail.com>
 * @contributor csanahuja <csanahuja10@gmail.com>
 *
 * https://github.com/jsanahuja/jquery.instagramFeed
 *
 */
(function($){
    var defaults = {
        'host': "https://www.instagram.com/",
        'username_or_tag': '',
        'tag': '',
        'container': '',
        'image_class': '',
        'get_data': false,
        'is_tag': false,
        'callback': null,
        'items': 8,
        'image_size': 640
    };
    var image_sizes = {
        "150": 0,
        "240": 1,
        "320": 2,
        "480": 3,
        "640": 4
    };
    var escape_map = {
        '&': '&amp;',
        '<': '&lt;',
        '>': '&gt;',
        '"': '&quot;',
        "'": '&#39;',
        '/': '&#x2F;',
        '`': '&#x60;',
        '=': '&#x3D;'
    };
    function escape_string(str){
        return str.replace(/[&<>"'`=\/]/g, function (char) {
            return escape_map[char];
        });
    }

    $.instagramFeed = function(opts){
        var options = $.fn.extend({}, defaults, opts);
        if(options.username_or_tag == ""){
            console.error("Instagram Feed: Error, no username or tag found.");
            return false;
        }
        if(typeof options.get_raw_json !== "undefined"){
            console.warn("Instagram Feed: get_raw_json is deprecated. See use get_data instead");
            options.get_data = options.get_raw_json;
        }
        if(!options.get_data && options.container == ""){
            console.error("Instagram Feed: Error, no container found.");
            return false;
        }
        if(options.callback == null){
            console.error("Instagram Feed: Error, no callback defined to get the raw json");
            return false;
        }

        var is_tag = options.is_tag,
            url = is_tag ? options.host + "explore/tags/"+ options.username_or_tag + "/" : options.host + options.username_or_tag + "/";

        $.get(url, function(data){
            try{
                data = data.split("window._sharedData = ")[1].split("<\/script>")[0];
            }catch(e){
                console.error("Instagram Feed: It looks like the profile you are trying to fetch is age restricted. See https://github.com/jsanahuja/InstagramFeed/issues/26");
                return;
            }
            data = JSON.parse(data.substr(0, data.length - 1));
            data = data.entry_data.ProfilePage || data.entry_data.TagPage;
            if(typeof data === "undefined"){
                console.error("Instagram Feed: It looks like YOUR network has been temporary banned because of too many requests. See https://github.com/jsanahuja/jquery.instagramFeed/issues/25");
                return;
            }
            data = data[0].graphql.user || data[0].graphql.hashtag;



            //Setting styles
            var styles = {
                'profile_container': "",
                'profile_image': "",
                'profile_name': "",
                'profile_biography': "",
                'gallery_image': ""
            };

            var html = "";


            //image size
            var image_index = typeof image_sizes[options.image_size] !== "undefined" ? image_sizes[options.image_size] : image_sizes[640];

                if(typeof data.is_private !== "undefined" && data.is_private === true){
                    html += "<p class='instagram_private'><strong>This profile is private</strong></p>";
                }else{
                    var imgs = (data.edge_owner_to_timeline_media || data.edge_hashtag_to_media).edges;
                    max = (imgs.length > options.items) ? options.items : imgs.length;


                    for(var i = 0; i < max; i++){
                        var url = "https://www.instagram.com/p/" + imgs[i].node.shortcode,
                            image, type_resource, caption;

                        switch(imgs[i].node.__typename){
                            case "GraphSidecar":
                                type_resource = "sidecar"
                                image = imgs[i].node.thumbnail_resources[image_index].src;
                                break;
                            case "GraphVideo":
                                type_resource = "video";
                                image = imgs[i].node.thumbnail_resources[image_index].src;
                                break;
                            default:
                                type_resource = "image";
                                image = imgs[i].node.thumbnail_resources[image_index].src;
                        }
                        if(
                            typeof imgs[i].node.edge_media_to_caption.edges[0] !== "undefined" &&
                            typeof imgs[i].node.edge_media_to_caption.edges[0].node !== "undefined" &&
                            typeof imgs[i].node.edge_media_to_caption.edges[0].node.text !== "undefined" &&
                            imgs[i].node.edge_media_to_caption.edges[0].node.text !== null
                        ){
                            caption = imgs[i].node.edge_media_to_caption.edges[0].node.text;
                        }else if(
                            typeof imgs[i].node.accessibility_caption !== "undefined" &&
                            imgs[i].node.accessibility_caption !== null
                        ){
                            caption = imgs[i].node.accessibility_caption;
                        }else{
                            caption = (is_tag ? data.name : data.username) + " image " + i;
                        }
                        html += "<div class='il-item "+ options.image_class + "'><div class='il-item-inner'>";
                        html += "<a href='" + url +"' class='instagram-" + type_resource + "' rel='noopener' target='_blank'>";
                        html += "<img src='" + image + "' alt='" + escape_string(caption) + "'  class='il-photo__img' />";
                        html += "<span class='il-photo__meta'>" +
                                    "<span class='il-photo__metainner'>" +
                                        "<span class='il-photo__comments'><i class='fa fa-comments-o'></i> " + imgs[i].node.edge_media_to_comment.count + "</span> " +
                                        "<span class='il-photo__likes'><i class='fa fa-heart-o'></i> " +  imgs[i].node.edge_media_preview_like.count + "</span>" +
                                    "</span>" +
                                "</span>";
                        html += "</a>";
                        html += "</div></div>";
                    }
                }

            $(options.container).html(html);

            options.callback(data);
        }).fail(function(e){
            console.error("Instagram Feed: Unable to fetch the given user/tag. Instagram responded with the status code: ", e.status);
        });

        return true;
    };

})(jQuery);